/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef PCI32REG_H
#define PCI32REG_H

/*
// ** IMPORTANT **
// This is a Win32 - ONLY set of functions.
// All registry access routines in Pci32Reg.c are Unicode-compliant.  
// Use _TCHAR instead of char and _tcs... macros to keep them that way.
*/

#include <wchar.h>

#include <typedefs.h>
#include <b_pci.h>    /* the device driver */

#include "lasterr.h"

/*
// This MUST agree with DEV_VERSION in b_ntpci.h or the program
// will NOT RUN (!!!!).  Thus compile times are important (!!!)
*/
#define CAPI_VERSION		DEV_VERSION

/*
// The first 5 functions are the main interface to the device-registry
*/

/* 1. Version check...returns B_E_OK or error code.  #Ifdef _DEBUG => B_E_OK  */
b_errtype BestNTRegVersionCheck( void );

/* 2. The "real" BestDevIdentifierGet() function  */
b_errtype BestNTRegDevIDGet( 
							b_int32 dwVendorId,
							b_int32 dwDeviceId,
							b_int32 dwSubsysId,
							b_int32 *pdwHPSlotId        /* returns HPSlotId */
							);

/*
// 3. After getting a valid HPSlotId this function returns a name that
//    can be used in the call to CreateFile() to get a handle to the Device.
*/
b_errtype BestNTRegDevNameGet( 
							b_int32 pdwHPSlotId,
						    _TCHAR * pszUserBuffer,     /* returns "CreateFile()" name */
                            b_int32 * pdwBufferSize     /* returned val = # of bytes read */
							);

/*
// 4. After successfully calling CreateFile() and getting a valid handle to the
//    device we need to claim ownership of the device.  
//    The uses for this mechanism are not fully developed yet.
*/
b_errtype BestNTRegOwnerSet(
                            b_int32 dwHPSlotId,
                            b_int32 * pdwCurrOwnerProcessId
							);

/*
// 5. On closing a device handle we release ownership
*/
b_errtype BestNTRegOwnerClear(
                            b_int32 dwHPSlotId,
                            b_int32 * pdwCurrOwnerProcessId
							);

/*
// These functions are exposed because we're not yet sure what we'll need.
*/
b_errtype BestNTRegDevEnumGet( 
                            b_int32 dwHPSlotId,
                            b_int32 * pdwDevNum     /* returned; index of dev. */
							);

b_errtype BestNTRegDWordGet( 
							const _TCHAR * pcszValueName,
							b_int32 dwDeviceEnum,
							b_int32 *pdwValue
							);

b_errtype BestNTRegDWordSet( 
							const _TCHAR * pcszValueName,
							b_int32 dwDeviceEnum,
							b_int32 dwValue
							);

/*
// This function is not strictly required as the only 2 strings in the Pci Device
// Registry are "Version" and "Name", both of which are accessed by other functions
// (BestNTRegVersionCheck() and BestNTRegDevNameGet()).  
// This is exposed for future music.
*/
b_errtype BestNTRegSzGet( 
						    const _TCHAR * pcszValueName,
						    b_int32 dwDeviceEnum,
						    _TCHAR * pszUserBuffer,
                            b_int32 * pdwBufferSize     /* returned val = # of bytes read */
						    );

#endif	/* PCI32REG_H */
